package servletPackage;

import dataHolderPackage.ZoneStorage;
import databasePackage.ZoneToDatabaseConnector;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;

import javax.xml.transform.stream.StreamResult;
//import org.jdom.output.XMLOutputter;
import org.jdom.output.XMLOutputter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;   //1
import org.w3c.dom.NodeList;
import org.jdom.ProcessingInstruction;


//import sun.org.mozilla.javascript.internal.json.JsonParser;
//import sun.org.mozilla.javascript.internal.json.Json;
//Not as familar with JSON personally, so we'll let the built-in module handle reading and writing JSON
//Instead, we mostly focus on matching values

/**
 * Servlet implementation class ZoneServlet
 */
@WebServlet(description = "Keeps track of the zones", urlPatterns = {"/ZoneServlet"}) //2
public class ZoneServlet extends HttpServlet {

    private static final long serialVersionUID = 1L;
    private ArrayList<ZoneStorage> zones;//3.) List of highest level Storage
    private static final boolean DEBUG = true;   //3  
    //ZoneServlet.class.getResource(
//    private final String xmlSrcFilePath = "/H:/pub_html/352/lFlickrAPICallsWorkNow/FlickrAPIProject2/view/dump.xml";
    private final String xsdSrcFilePath = "/H:/pub_html/352/lFlickrAPICallsWorkNow/FlickrAPIProject2/view/schema.xsd";
    private final String xslSrcFilePath = "index.xsl";
    private XMLOutputter xmlOut;
    private ZoneToDatabaseConnector zTDC;

    /**
     * Default constructor, used to ensure HttpServlet's super constructor is being called.
     */
    public ZoneServlet() {
        super();
    }

    /**
     * Here, we clear out the ArrayList of ZoneStorages so that we're working with only new data.
     * We then go and parse the XML file.
     */
    public void init(ServletConfig config) throws ServletException {

        //Re-initialise the array here, not in the field definition, for memory safety.
        zones = new ArrayList<ZoneStorage>();
        xmlOut = new XMLOutputter(org.jdom.output.Format.getPrettyFormat());
        System.out.println("Initiating database connection");
        zTDC = new ZoneToDatabaseConnector();
        System.out.println("System connection made - now pulling for images");
        zones = zTDC.pull();
//        loadXML(xmlSrcFilePath, xmlOut);

    }

    /**
     * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
     */
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (DEBUG) {
            System.out.println("doGet");
        }
        /*TODO:java.lang.NumberFormatException: For input string: ""49""
        sun.misc.FloatingDecimal.readJavaFormatString(FloatingDecimal.java:1224)
        java.lang.Double.parseDouble(Double.java:510)
        servletPackage.ZoneServlet.doGet(ZoneServlet.java:82)
        javax.servlet.http.HttpServlet.service(HttpServlet.java:621)
        javax.servlet.http.HttpServlet.service(HttpServlet.java:722)
        org.netbeans.modules.web.monitor.server.MonitorFilter.doFilter(MonitorFilter.java:393)
        
        http://localhost:8084/FlickrAPIProject2/ZoneServlet?latitude=49.188948&longitude=-122.847879&radius=5.0
         */

        Double lat = Double.parseDouble(request.getParameter("latitude"));
        Double lng = Double.parseDouble(request.getParameter("longitude"));
        Double radius = Double.parseDouble(request.getParameter("radius"));//8
        String photoSearchTerms = "Skytrain";
        int numOfPhotoGet = 5;
        System.out.println("Request received");

        org.jdom.Element root = new org.jdom.Element("locationcollection");

        org.jdom.Namespace xsiNS = org.jdom.Namespace.getNamespace("xsi",
                "http://www.w3.org/2001/XMLSchema-instance");

        //TODO: Schema Location?
        root.addNamespaceDeclaration(xsiNS);
        root.setAttribute("noNamespaceSchemaLocation", xsdSrcFilePath, xsiNS);//TODO: Why to access this file, and how

        for (int i = 0; i < zones.size(); i++) {
            ZoneStorage restnt = zones.get(i);//10
            Double restntLat = Double.parseDouble(restnt.getLatitude());
            Double restntLng = Double.parseDouble(restnt.getLongitude());

            if (DEBUG) {
                System.out.println(getEuclidianDistance(lat, lng, restntLat, restntLng).
                		           toString() + "radius: " + radius.toString());
            }

            if (getEuclidianDistance(lat, lng, restntLat, restntLng) <= radius) {//11
                //TODO: 
                
                //restnt.getPhotos().clear();
                //We reset photos here - therefore we requery them.
            	System.out.println("No photos previously found for this location - re-querying. (1/2)");
//              restnt.initiatePhotos(restntLat, restntLng, photoSearchTerms, numOfPhotoGet); // We do this within zTDC.pullImages, if necessary, so...
            	// Let's not.
                zTDC.pullImages(restnt);//So we re-pull images every call
                System.out.println("No photos previously found for this location - re-queryied. (2/2)");             

                root.addContent(restnt.convertToElement());
            }
        }

        org.jdom.Document doc = new org.jdom.Document();
        doc.setRootElement(root);//22

        HashMap<String, String> piMap = new HashMap<String, String>();
        piMap.put("type", "text/xsl");
        piMap.put("href", xslSrcFilePath);
        ProcessingInstruction pi = new ProcessingInstruction("xml-stylesheet", piMap);
        doc.getContent().add(0, pi);
//        sun.org.mozilla.javascript.internal.json.JsonParser jsonProductIn = new sun.org.mozilla.javascript.internal.json.JsonGenerator(new FileInputStream((new File("products.txt"))));
//        XMLOutputter xmlOut = new XMLOutputter(org.jdom.output.Format.getPrettyFormat());
        response.flushBuffer();
        response.getOutputStream().flush();
        response.setContentType("text/xml");
//        FileOutputStream debug = new FileOutputStream(new File("log.xml"));//TODO: For debugging? 
        xmlOut.output(doc, response.getOutputStream());//TODO: Or will the XML output get shown if Servlet is directly called?
//        xmlOut.output(doc, System.out);//TODO: Or will the XML output get shown if Servlet is directly called?
        System.out.println("Done");

        System.out.println("Done");
        //response.getOutputStream()
    }

    /**
     * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
     */
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        // TODO Auto-generated method stub
    }

    /**
     * 	
     * @param xmlFilePath
     */
    private void loadXML(String xmlFilePath, XMLOutputter xO) {
        try {
            File file = new File(xmlFilePath);

            if (DEBUG) {
                System.out.println("loading xml: " + file.getAbsolutePath());
                System.out.println(file.canRead());
            }
            //4.)
            if (file.exists()) {
                System.out.println("File exist: " + file.getAbsolutePath());
                DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = fact.newDocumentBuilder();
                Document doc = builder.parse(xmlFilePath);

                NodeList list1 = doc.getElementsByTagName("location");
                for (int i = 0; i < list1.getLength(); i++) {//5.)
                    Element rElement = (Element) list1.item(i);
                    //TODO: Change to appropriate xml document tags
                    ZoneStorage restnt = new ZoneStorage();

                    NodeList list2 = rElement.getElementsByTagName("*");
                    for (int j = 0; j < list2.getLength(); j++) {
                        Element element = (Element) list2.item(j);

                        if (element.getNodeName().equals("id")) {
                            restnt.setIdentifier(element.getTextContent());
                        }

                        if (element.getNodeName().equals("title")) {
                            restnt.setTitle(element.getTextContent());
                        }
                        if (element.getNodeName().equals("lines")) {
                            restnt.setLines(element.getTextContent());
                        }
                        if (element.getNodeName().equals("zone")) {
                            restnt.setZone(element.getTextContent());
                        }
                        if (element.getNodeName().equals("description")) {
                            restnt.setDescription(element.getTextContent());
                        }
//                        if (element.getNodeName().equals("name")) {
//                            restnt.setDescription(element.getTextContent());
//                        }
//                        if (element.getNodeName().equals("restaurant_image")) {
//                            restnt.setRestaurantImageURL(element.getAttribute("url"));
//                            restnt.setRestaurantImageWidth(element.getAttribute("width"));
//                            restnt.setRestaurantImageHeight(element.getAttribute("height"));
//                        }
                        if (element.getNodeName().equals("lat")) {

                            restnt.setLatitude(element.getTextContent());
                        }
                        if (element.getNodeName().equals("lon")) {

                            restnt.setLongitude(element.getTextContent());
                        }
//                        if (element.getNodeName().equals("surrounding_photos")) {
//                            restnt.setSurroundingPhotoSearchTag(element.getAttribute("search_tag"));
//                        }
                    }
                    restnt.setXMLOutputter(xO);
                    zones.add(restnt);
//                    restaurantsList.AddRestaurant(restnt);
                }
            } else {
                if (DEBUG) {
                    System.out.println("File not found!");
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Double getEuclidianDistance(Double x1, Double x2, Double y1, Double y2) {
        Double distance = 0.0;
        distance = distance + Math.pow((x1 - y1), 2);
        distance = distance + Math.pow((x2 - y2), 2);
        return Math.sqrt(distance) * 111;
    }
}
