package servletPackage;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.output.XMLOutputter;

import dataHolderPackage.ZoneStorage;
import databasePackage.ZoneToDatabaseConnector;
import secretsGrabbingPackage.SecretsGrabber;

@WebServlet(description = "Gets the API Key for Google Maps", urlPatterns = {"/GMapAPIKey"})
public class GMapKeyServlet extends HttpServlet{

    /**
	 * 
	 */
	private static final long serialVersionUID = 7637693406739924493L;
	private static final boolean DEBUG = true;   //3
	private static final String G_MAP_API_TYPE;
	private static final String G_MAP_API_FILEPATH;
	private static final String OPEN_MAP_API_TYPE;
	private static final String OPEN_MAP_API_FILEPATH;
	private static String G_MAP_API_KEY;
	private static String OPEN_MAP_API_KEY;
	
	private final String xsdSrcFilePath = "/H:/pub_html/352/lFlickrAPICallsWorkNow/FlickrAPIProject2/view/schema.xsd";
    //ZoneServlet.class.getResource(
//    private final String xmlSrcFilePath = "/H:/pub_html/352/lFlickrAPICallsWorkNow/FlickrAPIProject2/view/dump.xml";
//    private final String xsdSrcFilePath = "/H:/pub_html/352/lFlickrAPICallsWorkNow/FlickrAPIProject2/view/schema.xsd";
//    private final String xslSrcFilePath = "index.xsl";
    private XMLOutputter xmlOut;
//    private ZoneToDatabaseConnector zTDC;
	
	static {
		G_MAP_API_TYPE = "GoogleMapsAPIKey"; // In short, while this could be a Google Maps API Key, it may be a different type of Mapping key
											 // That would be dependent on what the JavaScript specifically wants to use.
											 // 
		G_MAP_API_FILEPATH = "/etc/secret-volume/.gMapAPIKey";
		G_MAP_API_KEY = SecretsGrabber.getSecret(G_MAP_API_FILEPATH, "googleMapsAPIKey");
		
		OPEN_MAP_API_TYPE = "OpenStreetMapsAPIKey";
		OPEN_MAP_API_FILEPATH = "/etc/secret-volume/.openStreetMapAPIKey";
		
		OPEN_MAP_API_KEY = SecretsGrabber.getSecret(OPEN_MAP_API_FILEPATH, "OpenStreetMapsAPIKey");
	}

    /**
     * Default constructor, used to ensure HttpServlet's super constructor is being called.
     */
    public GMapKeyServlet() {
        super();
    }

    /**
     * Here, we clear out the ArrayList of ZoneStorages so that we're working with only new data.
     * We then go and parse the XML file.
     */
    public void init(ServletConfig config) throws ServletException {
    	xmlOut = new XMLOutputter(org.jdom.output.Format.getPrettyFormat());
    }

    /**
     * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
     */
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (DEBUG) {
            System.out.println("doGet");
        }

        Element rootElement = new Element("keys");
        
        Namespace xsiNS = Namespace.getNamespace("xsi","http://www.w3.org/2001/XMLSchema-instance");

        rootElement.addNamespaceDeclaration(xsiNS);
        rootElement.setAttribute("noNamespaceSchemaLocation", xsdSrcFilePath, xsiNS);
        //  Now we want to add the base API Key as an element, so that we can pull it out.
        // Doing it this way to be consistent with the rest of the original server, and not switching to JSON just to make things consistent.
        // Also allows us to reuse JavaScript libraries that this project used back in 2011. They still work, so...
        Element apiKeyElement = new Element(G_MAP_API_TYPE); // toLowerCase to normalize how the XML tags look.
        
        apiKeyElement.addContent(G_MAP_API_KEY);
        
        Element openSMKeyElement = new Element(OPEN_MAP_API_TYPE);
        
        openSMKeyElement.addContent(OPEN_MAP_API_KEY);
        
        rootElement.addContent(apiKeyElement);
        rootElement.addContent(openSMKeyElement);
        
        // Okay, now to actually try and create the XML version of this output.
        Document gMapAPIDocument = new Document();
        gMapAPIDocument.setRootElement(rootElement);
//        XMLOutputter xmlOut = new XMLOutputter(org.jdom.output.Format.getPrettyFormat());
        response.flushBuffer();
        response.getOutputStream().flush();
        response.setStatus(200);
        response.setContentType("text/xml");
        xmlOut.output(gMapAPIDocument, response.getOutputStream());
    }

    /**
     * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
     */
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        // TODO Auto-generated method stub
    }
}
