package dataHolderPackage;
import java.io.BufferedReader;
import java.io.InputStreamReader;
//import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
//import java.util.List;
//import java.util.Scanner;
import java.util.List;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.jdom.input.SAXBuilder;
//import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
//import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import secretsGrabbingPackage.SecretsGrabber;




public class ZoneStorage {
	
    //Lets us use the FlickrAPI
	private static final String FLICKR_API_FILEPATH;
    private static final String FLICKR_API_KEY; //= "c8bb5da5c2ae356889bcee2d9469d6d9";
    
    static {
    	FLICKR_API_FILEPATH  = "/etc/secret-volume/.flickrAPIKey";
    	
    	FLICKR_API_KEY = SecretsGrabber.getSecret(FLICKR_API_FILEPATH, "flickrAPI");
    	
    }
        
	private String identifier = "";
	private String title = "";
	private String lines = "";
	private String description = "";
	private String latitude = "";
	private String longitude= "";
    private String zone = "";
	private ArrayList<ZonePhoto> photos = new ArrayList<ZonePhoto>();
    private XMLOutputter xO;
	
	public ZoneStorage(String id){
		setIdentifier(id);
		
	}
        
    public ZoneStorage(){
		
	}

	public void setIdentifier(String identifier) {
		this.identifier = identifier;
	}

	public String getIdentifier() {
		return identifier;
	}

	public void setTitle(String contact) {
		this.title = contact;
	}

	public String getTitle() {
		return title;
	}
        
        public void setLines(String contact) {
		this.lines = contact;
	}

	public String getLines() {
		return lines;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getDescription() {
		return description;
	}

	public void setLatitude(String latitude) {
		this.latitude = latitude;
	}

	public String getLatitude() {
		return latitude;
	}

	public void setLongitude(String longitude) {
		this.longitude = longitude;
	}

	public String getLongitude() {
		return longitude;
	}
	
        public Integer initiatePhotos(Double lat, Double lng,
            String photoSearchTerms, int numOfPhotos){
            boolean getGeoLocationCall = true;//12
            System.out.println("Initiating photos");

        try {

            String apiKey = URLEncoder.encode(FLICKR_API_KEY, "UTF8");
//            String secretKey = URLEncoder.encode("df35b8f71b8928f1", "UTF8");
            String tags = URLEncoder.encode(photoSearchTerms, "UTF8");
            String accuracy = URLEncoder.encode("16", "UTF8");
            String contentType = URLEncoder.encode("6", "UTF8");
            String hasGeo = URLEncoder.encode("1", "UTF8");
            String latitudeA = URLEncoder.encode(latitude.toString(), "UTF8");
            String longitudeA = URLEncoder.encode(longitude.toString(), "UTF8");
            String radius = URLEncoder.encode("0.5", "UTF8");
            String radiusUnits = URLEncoder.encode("km", "UTF8");
            String extras = URLEncoder.encode("url_t, url_m, url_o, geo", "UTF8");//13
            
            //Required to actually get any photos, therefore hardcoded do to ease of use
            String min_upload_date = URLEncoder.encode("098412", "UTF8");
            
            
            // This next bit is a bit weird, but was unable to get the SSL certificates to be trusted for flickr.com, apparently ("Amazon Root CA 1"?)
            // That is, the container can trust it, but getting Java to recognize the same trust level has been...difficult.
            // So the hack involved here, to at least make some progress on updating this, is to tell Java to trust *all* certificates.
            // TODO: Hopefully replace this with a proper way to trust HTTPS connections, because this is...very bad.
            // Create a trust manager that does not validate certificate chains 
            final TrustManager[] trustAllCerts = new TrustManager[] { 
            		new X509TrustManager() { 
            			@Override 
            			public void checkClientTrusted( 
            					final X509Certificate[] chain, final String authType ) { 
            				
            			} 
            			@Override 
            			public void checkServerTrusted( final X509Certificate[] chain, final String authType ) { } 
            			@Override 
            			public X509Certificate[] getAcceptedIssuers() { 
            				return null; }
            			} 
            		};
            
         // Install the all-trusting trust manager
            final SSLContext sslContext = SSLContext.getInstance( "SSL" );
            sslContext.init( null, trustAllCerts, new java.security.SecureRandom() );
            // Create an ssl socket factory with our all-trusting manager
            final SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            

            //TODO: Make private variable
            String flickrPhotoSearchRequestURL = "https://api.flickr.com/services/rest/?"
                    + "method=flickr.photos.search&api_key=" + apiKey
                    + "&tags=" + tags + "&accuracy=" + accuracy
                    + "&content_type=" + contentType + "&has_geo=" + hasGeo + "&lat=" + latitudeA
                    + "&lon=" + longitudeA
                    + "&radius=" + radius + "&radius_units=" + radiusUnits + "&extras=" + extras + "&min_upload_date=" + min_upload_date + "&format=rest";//14

            HttpsURLConnection con = (HttpsURLConnection) (new URL(flickrPhotoSearchRequestURL)).openConnection();
            //con.setInstanceFollowRedirects(false);//15 - since redirects are expected, we want the actual final response, hopefully?
            con.setSSLSocketFactory(sslSocketFactory);
            //TODO: Check for images here, and check *why* it isn't doing what we want it to.
            
            //TODO:
            
            //TODO:
            
//            System.out.println("Flickr Response: \n" + con.getResponseMessage());
            //Used to debug if getting xml data and why it isn't picking up
            /*String received = "";
            while(con.getInputStream().available() != 0){
                received += ((Integer)con.getInputStream().read()).toString();
            }
            System.out.println("Byte content: \n" + received);*/
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            //fact.setNamespaceAware(true);
            DocumentBuilder builder = fact.newDocumentBuilder();
            //System.out.println("Input stream content");
            /*BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuilder photoStreamBuilder = new StringBuilder("");
            while(reader.ready()) {
            	photoStreamBuilder.append(reader.readLine() + System.lineSeparator());
            }
//            
            System.out.println("Expected parseable");
//            
            System.out.println(photoStreamBuilder.toString());*/
//            
            System.out.println("Attempting parsing");
            
            Document doc = builder.parse(con.getInputStream());//16
            //org.jdom.Document doca = (org.jdom.Document) doc;
//            System.out.println("Flickr Data: \n Finished parsing: \n" + doc.toString());
            //getXMLOutputter().output(doca, System.out);
            
//            NodeList list = doc.
            
            /*SAXBuilder builder = new SAXBuilder();

            org.jdom.Document doc = builder.build(flickrPhotoSearchRequestURL);
            org.jdom.Element e = doc.getRootElement();
            this.getXMLOutputter().output(doc, System.out);
            List list = e.getChild("photos").getChildren();*/

            NodeList listDebug = doc.getElementsByTagName("photo");
            System.out.println("Lists of photos: " + listDebug.getLength());
            NodeList list = doc.getElementsByTagName("photo");
            int listSize = list.getLength();//17
            System.out.println("Photos gotten:" + listSize);
            for (int i = 0; i < list.getLength(); i++) {
                if ((photos.size() < numOfPhotos) && (list.item(i) instanceof Element)) {               
                    
                    Element element = (Element) list.item(i);
                    System.out.println("Parsing element: " + element);
//                    Integer 
                       //18
                    //TODO: Pull elements in here, then place into constructor 
                    ZonePhoto fPhoto = new ZonePhoto();
                    try{
                        fPhoto.setIdentifier(Integer.parseInt(element.getAttribute("id")));
                        fPhoto.setTitle(element.getAttribute("title"));
//                    fPhoto.setOwner(element.getAttribute("owner"));
//                    fPhoto.setSecret(element.getAttribute("secret"));
//                    fPhoto.setServer(element.getAttribute("server"));
//                    fPhoto.setFarm(element.getAttribute("farm"));
//                    fPhoto.setIspublic(element.getAttribute("ispublic"));
//                    fPhoto.setIsfriend(element.getAttribute("isfriend"));
//                    fPhoto.setIsfamily(element.getAttribute("isfamily"));
                    fPhoto.setThumbnail(element.getAttribute("url_t"), element.getAttribute("width_t"), element.getAttribute("height_t"));
                    fPhoto.setMainImage(element.getAttribute("url_m"), element.getAttribute("width_m"), element.getAttribute("height_m"));
                    //TODO: Why won't Download Image take infomation in correctly?
                    fPhoto.setDownloadImage(element.getAttribute("url_o"), element.getAttribute("width_o"), element.getAttribute("height_o"));
//                    fPhoto.setHeight_t(element.getAttribute("height_t"));
//                    fPhoto.setUrl_m(element.getAttribute("url_m"));
//                    fPhoto.setHeight_m(element.getAttribute("height_m"));
//                    fPhoto.setWidth_m(element.getAttribute("width_m"));
                    fPhoto.setLatitude(Double.parseDouble(element.getAttribute("latitude")));
                    fPhoto.setLongitude(Double.parseDouble(element.getAttribute("longitude")));
//                    fPhoto.setAccuracy(element.getAttribute("accuracy"));
//                    fPhoto.setPlace_id(element.getAttribute("place_id"));
//                    fPhoto.setWoeid(element.getAttribute("woeid"));
//                    fPhoto.setGeo_is_family(element.getAttribute("geo_is_family"));
//                    fPhoto.setGeo_is_friend(element.getAttribute("geo_is_friend"));
//                    fPhoto.setGeo_is_contact(element.getAttribute("geo_is_contact"));
//                    fPhoto.setGeto_is_public(element.getAttribute("geo_is_public"));*/

//                    if (getGeoLocationCall) {
//                        flickrPhotoSearchRequestURL =
//                                "http://api.flickr.com/services/rest/?"
//                                + "method flickr.photos.geo.getLocation&api_key=" + apiKey
//                                + "&photo_id=" + element.getAttribute("id");
//                        con = (HttpURLConnection) (new URL(flickrPhotoSearchRequestURL)).openConnection();
//                        con.setInstanceFollowRedirects(false);
//
//                        fact = DocumentBuilderFactory.newInstance();
//                        builder = fact.newDocumentBuilder();
//                        doc = builder.parse(con.getInputStream());
//                        //19
//                        NodeList list2 = doc.getElementsByTagName("location");
//
////                        if (list2.getLength() > 0) {
////                            Element element2 = (Element) list2.item(0);
////                            System.out.println("call1: " + element.getAttribute("latitude") + " " + element.getAttribute("longitude"));
////                            System.out.println("call2: " + element2.getAttribute("latitude") + " " + element2.getAttribute("longitude"));
////                            System.out.println("Compare Coordinate from search and get.geolocation: lat same=" + (element.getAttribute("latitude").
////                                    equals(element2.getAttribute("latitude"))) + "; lng same=" + (element.getAttribute("longitude").equals(element2.getAttribute("longitude"))));
////                            //*	
//////                            fPhoto.setLatitude(element2.getAttribute("latitude"));
//////                            fPhoto.setLongitude(element2.getAttribute("longitude"));
////
////                        }
//                    }
                    photos.add(fPhoto);
                    System.out.println("Added photo: " + fPhoto.getTitle());
                    }catch(Exception a){
                        System.out.println("Could not parse: photo iteration " + i + ": " + element.toString());
                        continue;//In case parsing identifier breaks
                    }
                    
                    
                    
                } else if (photos.size() >= numOfPhotos){
                	System.out.println("Found enough photos");
                    break;
                }else {
                	System.out.println("Item is not element apparently: " + i + " : " + list.item(i).toString());
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
            return photos.size();
        }
        
//	//TODO: Boolean indicates success
//	public boolean addPhoto(Integer id){
//		testingDebug("Add Photo");
//		
//		return false;
//		//return true;
//	}
//	
//	//TODO: Boolean indicates success
//	public boolean removePhoto(Integer id){
//            testingDebug("Remove Photo");
//		for(ZonePhoto zp: photos){
//			if(zp.getIdentifier().equals(id)){
//				photos.remove(zp);
//                                return true;
//			}
//		}
//		return false;
//	}
	
public org.jdom.Element convertToElement() {
    	
        org.jdom.Element restntElement = new org.jdom.Element("location");//20
//        restntElement.setAttribute("id", restnt.getID());

        restntElement.addContent(new org.jdom.Element("id").addContent(this.getIdentifier()));
        restntElement.addContent(new org.jdom.Element("title").addContent(this.getTitle()));
        restntElement.addContent(new org.jdom.Element("lines").addContent(this.getLines()));
        restntElement.addContent(new org.jdom.Element("zone").addContent(this.getZone()));
        restntElement.addContent(new org.jdom.Element("description").addContent(this.getDescription()));
//        restntElement.addContent(new org.jdom.Element("detail_link").addContent(restnt.getDetailLink()));
//        restntElement.addContent(new org.jdom.Element("reviews").addContent(restnt.getReviews()));
//
//        org.jdom.Element rImageElement = new org.jdom.Element("restaurant_image");
//        rImageElement.setAttribute("url", restnt.getRestaurantImageURL());
//        rImageElement.setAttribute("width", restnt.getRestaurantImageWidth());
//        rImageElement.setAttribute("height", restnt.getRestaurantImageHeight());
//        restntElement.addContent(rImageElement);

        restntElement.addContent(new org.jdom.Element("lat").addContent(this.getLatitude()));
        restntElement.addContent(new org.jdom.Element("lon").addContent(this.getLongitude()));
//        restntElement.addContent(coordinateElement);

//        org.jdom.Element sPhotoElement = new org.jdom.Element("surrounding_photos");
//        sPhotoElement.setAttribute("search_tag", restnt.getSurroundingPhotoSearchTag());
        for (int i = 0; i < this.photos.size(); i++) {//21
            ZonePhoto photo = this.photos.get(i);
            //We let each individual photo element render itself - saves time.
            org.jdom.Element photoElement = photo.renderImage();
            //new org.jdom.Element("photo");
            
            restntElement.addContent(photoElement);
        }
//        restntElement.addContent(sPhotoElement);

        return restntElement;
    }
	
	
	
    private void testingDebug(String loremIpsum){
	System.out.println("Zone Storage Debug: " + loremIpsum);
    }

    /**
     * @return the zone
     */
    public String getZone() {
        return zone;
    }

    /**
     * @param zone the zone to set
     */
    public void setZone(String zone) {
        this.zone = zone;
    }
    
    /**
     * Sets the XML Outputter as provided - used for debugging
     * @param xi - the XML Outputter.
     */
    public void setXMLOutputter(XMLOutputter xi){
        xO = xi; 
    }
    
    public XMLOutputter getXMLOutputter(){
        if(xO == null){
            xO = new XMLOutputter(org.jdom.output.Format.getPrettyFormat());
        }
        return xO;
    }

    public int getPhotoSize() {
        return photos.size();
    }

    public ArrayList<ZonePhoto> getPhotos() {
        return photos;
    }
	
}
