package dataHolderPackage;

public class ZonePhoto {
	private Integer identifier;
	private String title;
	private Double latitude;
	private Double longitude;
	private Thumbnail thumbnail;
	private MainPhoto mainImage;
	private DownloadableImage downloadImage;
	
	public ZonePhoto(Integer identifier, String titlea, Double lat, Double lon, String t_url, String t_width, String t_height, 
					String m_url, String m_width, String m_height,
					String d_url, String d_width, String d_height){
		setIdentifier(identifier);
		setTitle(title);
		setLatitude(lat);
		setLongitude(lon);
		thumbnail = new Thumbnail(t_url, t_width, t_height);
		mainImage = new MainPhoto(m_url, m_width, m_height);
		downloadImage = new DownloadableImage(d_url, d_width, d_height);
	}
	
	public ZonePhoto(){
		
	}
        

	public void setThumbnail(String t_url, String t_width, String t_height) {
		this.thumbnail = new Thumbnail(t_url, t_width, t_height);
	}

	public Thumbnail getThumbnail() {
		return thumbnail;
	}

	public void setMainImage(String t_url, String t_width, String t_height) {
		this.mainImage = new MainPhoto(t_url, t_width, t_height);
	}

	public MainPhoto getMainImage() {
		return mainImage;
	}

	public void setDownloadImage(String t_url, String t_width, String t_height) {
		this.downloadImage = new DownloadableImage(t_url, t_width, t_height);
	}

	public DownloadableImage getDownloadImage() {
		return downloadImage;
	}

	public void setIdentifier(Integer identifier) {
		this.identifier = identifier;
	}

	public Integer getIdentifier() {
		return identifier;
	}
	private void testingDebug(String loremIpsum){
		System.out.println("Zone Photo Debug: " + loremIpsum);
	}
        //Public element generation
	public org.jdom.Element renderImage(){
		org.jdom.Element renderableImage = new org.jdom.Element("photo");
		renderableImage.addContent(new org.jdom.Element("id").addContent(this.getIdentifier().toString()));
		renderableImage.addContent(new org.jdom.Element("p_title").addContent(this.getTitle()));
		renderableImage.addContent(new org.jdom.Element("p_lat").addContent(this.getLatitude().toString()));
		renderableImage.addContent(new org.jdom.Element("p_lon").addContent(this.getLongitude().toString()));
//		renderableImage.setAttribute("farm", photo.getFarm());
//		renderableImage.setAttribute("title", photo.getTitle());
//		renderableImage.setAttribute("ispublic", photo.getIspublic());
//		renderableImage.setAttribute("isfriend", photo.getIsfriend());
//		renderableImage.setAttribute("isfamily", photo.getIsfamily());
		renderableImage.addContent(this.thumbnail.renderImage());
//		renderableImage.setAttribute("url_t", photo.getUrl_t());
//		renderableImage.setAttribute("height_t", photo.getHeight_t());
//		renderableImage.setAttribute("width_t", photo.getWidth_t());
		renderableImage.addContent(this.mainImage.renderImage());
//		renderableImage.setAttribute("url_m", photo.getUrl_m());
//		renderableImage.setAttribute("height_m", photo.getHeight_m());
//        photoElement.setAttribute("width_m", photo.getWidth_m());

         //TODO: Why won't downloadable Image render correctly?
         renderableImage.addContent(this.downloadImage.renderImage());
//        photoElement.setAttribute("accuracy", photo.getAccuracy());
//        photoElement.setAttribute("place_id", photo.getPlace_id());
//        photoElement.setAttribute("woeid", photo.getWoeid());
//        photoElement.setAttribute("geo_is_family", photo.getGeo_is_family());
//        photoElement.setAttribute("geo_is_friend", photo.getGeo_is_friend());
//        photoElement.setAttribute("geo_is_contact", photo.getGeo_is_contact());
//        photoElement.setAttribute("geo_is_public", photo.getGeo_is_public());
        return renderableImage;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getTitle() {
		return title;
	}

	public void setLatitude(Double latitude) {
		this.latitude = latitude;
	}

	public Double getLatitude() {
		return latitude;
	}

	public void setLongitude(Double lon) {
		this.longitude = lon;
	}

	public Double getLongitude() {
		return longitude;
	}
}
