CREATE DATABASE iat_352_project_3_alexander_ryan;

CREATE TABLE iat_352_project_3_alexander_ryan.lines_table (
  `ID` int(11) NOT NULL,
  `LINE` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`ID`)
);

CREATE TABLE iat_352_project_3_alexander_ryan.locations (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `TITLE` varchar(255) NOT NULL,
  `DESCRIPTION` varchar(1024) NOT NULL,
  `ZONE` int(11) NOT NULL,
  `LINES` int(11) NOT NULL,
  `LATITUDE` double NOT NULL,
  `LONGITUDE` double NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `LINES_ID` (`LINES`),
  CONSTRAINT `LINES_ID` FOREIGN KEY (`LINES`) REFERENCES `lines_table` (`ID`) ON DELETE CASCADE ON UPDATE NO ACTION
);

CREATE TABLE iat_352_project_3_alexander_ryan.photo_expiration_log (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `TIME_OF_QUERY` time NOT NULL,
  `DATE_OF_QUERY` date DEFAULT NULL,
  PRIMARY KEY (`ID`)
);

CREATE TABLE iat_352_project_3_alexander_ryan.photos (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `LOCATION_ID` int(11) NOT NULL,
  `PHOTO_EXPIRATION_LOG_ID` int(11) NOT NULL,
  `LATITIDUE` double NOT NULL,
  `LONGITUDE` double NOT NULL,
  `T_URL` varchar(1024) DEFAULT NULL,
  `T_WIDTH` int(11) NOT NULL DEFAULT '100',
  `T_HEIGHT` int(11) NOT NULL DEFAULT '75',
  `M_URL` varchar(1024) DEFAULT NULL,
  `M_WIDTH` int(11) NOT NULL DEFAULT '400',
  `M_HEIGHT` int(11) NOT NULL DEFAULT '320',
  `D_URL` varchar(1024) DEFAULT NULL,
  `D_WIDTH` int(11) NOT NULL DEFAULT '1024',
  `D_HEIGHT` int(11) NOT NULL DEFAULT '800',
  `TITLE` varchar(1024) DEFAULT NULL,
  `ALTERNATE` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `LOCATION_ID` (`LOCATION_ID`),
  KEY `EXPIRATION_ID` (`PHOTO_EXPIRATION_LOG_ID`),
  CONSTRAINT `EXPIRATION_ID` FOREIGN KEY (`PHOTO_EXPIRATION_LOG_ID`) REFERENCES `photo_expiration_log` (`ID`) ON DELETE CASCADE ON UPDATE NO ACTION,
  CONSTRAINT `LOCATION_ID` FOREIGN KEY (`LOCATION_ID`) REFERENCES `locations` (`ID`) ON DELETE NO ACTION ON UPDATE NO ACTION
);

