<?xml version="1.0" encoding="ISO-8859-1"?>

<!-- IMPORTANT HEADING BELOW -->

<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="/">
  <html>
  <body>
  <h2>Marked Locations</h2>
  <table border="1">
    <tr bgcolor="#9acd32">
      <th>Information</th>
      <th>Images</th>
    </tr>
    <!-- Here, we load the information for each of the locations marked above -->
    <xsl:for-each select="locationcollection/location">
    	<tr>
      		<td><b><xsl:value-of select="title" /></b>
			<br /> Runs on: <i><xsl:value-of select="lines" /></i>
			<br /> Zone: <b><xsl:value-of select="zone" /></b>
			

	<!-- Double break for extra space -->	
	<br /><br /><xsl:value-of select="description"/>
	<br />.</td>
      	
	<td><!-- Image code goes here -->
		<table><tr>
		<xsl:for-each select="photo">
			<td style = "padding: 5px;">
				<img>
					<xsl:attribute name = "src">
						<xsl:value-of select="main/m_url"/>
					</xsl:attribute>
					<xsl:attribute name = "width">
						<xsl:value-of select="main/m_width" />
					</xsl:attribute>
					<xsl:attribute name = "height">
						<xsl:value-of select="main/m_height" />
					</xsl:attribute>
					<xsl:attribute name = "alt">
						<xsl:value-of select="p_title" />
					</xsl:attribute>
					<xsl:attribute name = "title">
						<xsl:value-of select="p_title" />
					</xsl:attribute>
				</img>
		</td>
		</xsl:for-each>
		</tr></table>

	<!-- Link to map marker-->
	
	</td>
    </tr>
    </xsl:for-each>
  </table>
  </body>
  </html>
</xsl:template>

</xsl:stylesheet> 